// XISLOutputTTS.cpp: CXISLOutputTTS NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLOutputTTS.h"
#include "XISLVar.h"
#include "XISLExcItem.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLOutputTTS::CXISLOutputTTS()
{
	m_nTagType = ID_TAG_OUTPUT;
	m_nBmpID = IDB_TTS;
	m_nOutputType = ID_OUTPUTTYPE_TTS;

	m_pParentTag = NULL;
	m_pTextList = NULL;
	m_nCharactor = 0;
	m_bEndSync = TRUE;
	m_nOutputEvent = -1;
}

CXISLOutputTTS::~CXISLOutputTTS()
{
	if(m_pTextList)
	{
		InitTextList();
		delete m_pTextList;
	}
}

CXISLOutputTTS::CXISLOutputTTS(const CXISLOutputTTS &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_nOutputEvent = cpXISL.m_nOutputEvent;
	m_nOutputType = cpXISL.m_nOutputType;

	m_nCharactor = cpXISL.m_nCharactor;
	m_bEndSync = cpXISL.m_bEndSync;
	m_strText = cpXISL.m_strText;
}

CXISLOutputTTS& CXISLOutputTTS::operator=(const CXISLOutputTTS &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_nOutputEvent = cpXISL.m_nOutputEvent;
		m_nOutputType = cpXISL.m_nOutputType;

		m_nCharactor = cpXISL.m_nCharactor;
		m_bEndSync = cpXISL.m_bEndSync;
		m_strText = cpXISL.m_strText;
	}
	return *this;
}

//void CXISLOutputTTS::GetDrawString(CString &strText)
//@\@F\peLXg擾
//@FCString :i[p
//ԂlFvoid
void CXISLOutputTTS::GetDrawString(CString &strText)
{
	switch(m_nOutputEvent)
	{
	case ID_TTSEVENT_SCHAR:
		strText = "ύX:";
		strText += SPEECH_CHARACTOR[m_nCharactor];
		break;
	case ID_TTSEVENT_SPEECH:
		GetText(strText);
		strText.Insert(0,"speech:\n");
		break;
	}
}

//LPCTSTR CXISLOutputTTS::GetXISLString()
//@\@FactionȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLOutputTTS::GetXISLString()
{
	CString strOutputType = XISL_OUTPUT_TYPE[m_nOutputType];
	CString strOutputEvent = XISL_OUTPUT_EVENT[m_nOutputEvent];

	m_strXISL = "<output type=\"" + strOutputType;
	m_strXISL += "\" event=\"";
	m_strXISL += strOutputEvent;
	m_strXISL += "\">\r\n";
	m_strXISL += "<![CDATA[\r\n";

	if(m_nOutputEvent == ID_TTSEVENT_SCHAR)
	{
		m_strXISL += "<param name=\"speaker\">";
		m_strXISL += SPEECH_CHARACTOR[m_nCharactor];
		m_strXISL += "</param>\r\n";
	}
	else if(m_nOutputEvent == ID_TTSEVENT_SPEECH)
	{
		CString strText;
		m_strXISL += "<param name=\"text\">";
		GetText(strText);
		m_strXISL += strText;
		m_strXISL += "</param>\r\n";

		m_strXISL += "<param name=\"endsync\">";
		if(m_bEndSync)
			m_strXISL += "on";
		else
			m_strXISL += "off";
		m_strXISL += "</param>\r\n";
	}
	m_strXISL += "]]>\r\n</output>\r\n";
	return m_strXISL;
}

//BOOL CXISLOutputTTS::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLOutputTTS::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_OUTPUT];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	return TRUE;
}

LPCTSTR CXISLOutputTTS::GetText(CString &strText)
{
	if(m_nOutputEvent != ID_TTSEVENT_SPEECH)
		ASSERT(NULL);

	m_strText.Empty();
	strText.Empty();
	CString strVarName;
	POSITION pos = m_pTextList->GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_pTextList->GetNext(pos);
		if(pVar->IsDummy())
		{
			m_strText += pVar->GetVarName();
			strText += pVar->GetVarName();
		}
		else
		{
			m_strText += " $";
			m_strText += pVar->GetVarName();
			m_strText += " ";

			pVar->GetVarNameEx(strVarName);
			strText += "<value expr=\"";
			strText += strVarName;
			strText += "\"/>";
		}
	}

	return m_strText;
}

BOOL CXISLOutputTTS::SetText(CPtrList *pTextList)
{
	InitTextList();
	if(m_pTextList==NULL)
		m_pTextList = new CPtrList;

	POSITION pos = pTextList->GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)pTextList->GetNext(pos);
		m_pTextList->AddTail(pVar);
		pVar->ReferCount(TRUE);
	}

	m_nOutputEvent = ID_TTSEVENT_SPEECH;
	return TRUE;
}

BOOL CXISLOutputTTS::SetText(LPCTSTR lpszTextList)
{
	if(m_pTextList==NULL)
		m_pTextList = new CPtrList;

	CString strText = lpszTextList;
	int nStart=0;
	CXISLVar *pText=NULL;
	CString strVarName;
	BOOL bOK = TRUE;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
	while(1)
	{
		if(strText.IsEmpty())
			break;
		nStart = strText.Find("<value",0);

		if(nStart == -1)
		{
			pText = new CXISLVar;
			pText->SetAttribute(strText,"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			break;
		}
		if(nStart != 0)
		{
			pText = new CXISLVar;
			pText->SetAttribute(strText.Left(nStart),"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			strText.Delete(0,nStart);
		}
		else
		{
			nStart = strText.Find("\"/>");
			if(nStart == -1)
			{
				AfxMessageBox("<value>̕^O܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			strVarName = strText.Left(nStart+1);
			int nIndex = strVarName.Find("expr",0);
			if(nStart == -1)
			{
				AfxMessageBox("<value>expr܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			
			nIndex = strVarName.Find("\"",nIndex);
			int nEnd = strVarName.ReverseFind('"');
			strVarName = strVarName.Mid(nIndex+1,nEnd-nIndex-1);
			CXISLVar *pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
			if(pVar == NULL)
			{
				AfxMessageBox("݂Ȃϐw肳܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			strText.Delete(0,nStart+2);
			m_pTextList->AddTail(pVar);
			pVar->ReferCount(TRUE);
		}
	}

	if(!bOK)
		InitTextList();
	else
		m_nOutputEvent = ID_TTSEVENT_SPEECH;

	return bOK;
}

void CXISLOutputTTS::InitTextList()
{
	if(m_pTextList == NULL)
		return;

	//_~[CXISLVar͍폜
	while(!m_pTextList->IsEmpty())
	{
		CXISLVar *pVar = (CXISLVar*)m_pTextList->RemoveHead();
		if(pVar->IsDummy())
			delete pVar;
		else
			pVar->ReferCount(FALSE);
	}
}

BOOL CXISLOutputTTS::SetAttribute(LPCTSTR lpszEvent,LPCTSTR lpszParam)
{
	if(strcmp(lpszEvent,XISL_OUTPUT_EVENT[ID_TTSEVENT_SCHAR]) == 0)
		m_nOutputEvent = ID_TTSEVENT_SCHAR;
	else if(strcmp(lpszEvent,XISL_OUTPUT_EVENT[ID_TTSEVENT_SPEECH]) == 0)
	{
		m_pTextList = new CPtrList;
		m_nOutputEvent = ID_TTSEVENT_SPEECH;
	}
	else
	{
		AfxMessageBox("`ĂȂeventł",MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
		return FALSE;
	}

	CString strParam = lpszParam;
	CString strParamName;
	CString strValue;
	int nIndex=0,nStart=0,nEnd=0;
	while(1)
	{
		nIndex = strParam.Find("<param",nIndex);
		if(nIndex==-1)
			break;

		nIndex = strParam.Find("name",nIndex);
		nStart = strParam.Find("\"",nIndex);
		nStart++;
		nEnd = strParam.Find("\"",nStart);
		strParamName = strParam.Mid(nStart,nEnd-nStart);

		nStart = strParam.Find(">",nEnd);
		nStart++;
		nEnd = strParam.Find("</param",nStart);
		strValue = strParam.Mid(nStart,nEnd-nStart);
		nIndex = nEnd + 1;

		if(strParamName.Compare("text")==0)
		{
			if(m_nOutputEvent != ID_TTSEVENT_SPEECH)
				return FALSE;
			m_strText = strValue;
			if(!SetText(m_strText))
				return FALSE;
		}
		else if(strParamName.Compare("speaker")==0)
		{
			if(m_nOutputEvent != ID_TTSEVENT_SCHAR)
				return FALSE;
			int nChar=SCHAR_MALE01;
			while(1)
			{
				if(nChar > SCHAR_FEMALE01)
				{
					AfxMessageBox("<param name=\"speaker\">̒lsł"
						,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
					return FALSE;
				}
				if(strcmp(SPEECH_CHARACTOR[nChar],strValue) == 0)
					break;
				nChar++;
			}
			m_nCharactor = nChar;
		}
		else if(strParamName.Compare("endsync")==0)
		{
			if(m_nOutputEvent != ID_TTSEVENT_SPEECH)
				return FALSE;

			if(strValue.Compare("on")==0)
				m_bEndSync = TRUE;
			else if(strValue.Compare("off")==0)
				m_bEndSync = FALSE;
			else
			{
				AfxMessageBox("<param name=\"endsync\">̒lsł"
					,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
				return FALSE;
			}
		}
	}
	return TRUE;
}

int CXISLOutputTTS::GetCharactor()
{
	if(m_nOutputEvent == ID_TTSEVENT_SCHAR)
		return m_nCharactor;

	ASSERT(NULL);
	return 0;
}

BOOL CXISLOutputTTS::SetCharactor(int nCharactor)
{
	if(m_pTextList)
	{
		delete m_pTextList;
		m_pTextList = NULL;
	}
	m_nOutputEvent = ID_TTSEVENT_SCHAR;
	if(nCharactor < SCHAR_MALE01 || nCharactor > SCHAR_FEMALE01)
		return FALSE;
	m_nCharactor = nCharactor;
	return TRUE;
}

